## 基于CCE Kubernetes编排实战


#### 实验一：创建CCE集群及创建节点

任务1：创建CCE集群及创建节点

得分点：能按要求成功配置CCE集群

提示：集群创建预计需要10分钟左右，可以单击 “查看集群事件列表”后查看集群详情。为节约时间，可在集群创建期间进入实验二，进行kubectl的安装操作。

CCE集群的配置参数如下，其余参数请保持默认。 计费模式: 按需付费 区域:华为-北京四 集群名称: 请命名为cce-k8s，否则无法进行验证 集群版本: 选择推荐的版本 集群管理规模: 50节点 集群Master数：单节点 虚拟私有云: vpc-cce（实验已预置） 网络模型: 容器隧道网络 容器网段: 选择“自动设置网段” 服务网段: 使用默认网段 插件选择：关闭云原生监控插件 其余参数: 保持默认
节点配置参数如下，其余参数请保持默认。 计费模式：按需付费 可用区：选择“随机分配” 节点名称：自定义节点名称，建议使用cce-k8s-node-01 节点规格：c6s.xlarge.2，4核|8GB 容器引擎：Containerd 操作系统：选择“公共镜像EulerOS 2.9” 系统盘：高IO，40GiB 数据盘：高IO，100GiB 虚拟私有云所在子网：选择默认子网 弹性IP：选择“自动创建” 规格：全动态BGP 计费模式：按流量计费 带宽大小 ：5M 登录方式：选择“密码”，自定义登录密码 本任务中需注意按需购买资源，并按指导参数配置CCE集群，否则不得分。


任务1步骤：

略，以下AI生成

此任务通过华为云CCE控制台完成。

登录华为云控制台。

导航到“云容器引擎 CCE”服务。

创建集群控制面

点击“购买Kubernetes集群”或“创建集群”。
计费模式: 按需付费
区域: 华为-北京四
集群名称: cce-k8s (务必使用此名称)
集群版本: 选择推荐的版本
集群管理规模: 50节点
集群Master数: 单节点
虚拟私有云(VPC): vpc-cce (选择实验已预置)
网络模型: 容器隧道网络
容器网段: 选择“自动设置网段”
服务网段: 使用默认网段
插件选择: 关闭云原生监控插件
其余参数: 保持默认
确认并创建集群控制面。
等待集群控制面创建成功。

创建节点

(在集群管理界面，选择

cce-k8s
集群，点击“节点管理” -> “创建节点”或“添加节点”)：

计费模式: 按需付费

可用区: 选择“随机分配”

节点名称: 自定义，建议 cce-k8s-node-01

节点规格: c6s.xlarge.2 (4核 | 8GB)

容器引擎: Containerd

操作系统: 选择“公共镜像 EulerOS 2.9”

系统盘: 高IO，40GiB

数据盘: 高IO，100GiB

虚拟私有云所在子网: 选择默认子网 (应为vpc-cce下的可用子网)

弹性公网IP

: 选择“自动创建”

规格: 全动态BGP
计费模式: 按流量计费
带宽大小: 5Mbit/s
登录方式: 选择“密码”，自定义登录密码。

其余参数: 保持默认

确认配置并创建节点。等待节点成功加入集群。


#### 实验二：使用kubectl操作CCE集群

任务1：安装并配置kubectl

得分点：能在ecs-terminal中正确安装kubectl客户端。

提示信息如下：

kubectl具体的安装步骤以及配置文件的下载路径可参考：“CCE控制台 > 集群管理 > 集群cce-k8s > 连接信息 > kubectl”
kubectl客户端安装完成后，其配置文件所在路径：kubernetes/client/bin/kubectl (此为kubectl二进制文件路径，配置文件通常是kubeconfig)
kubectl客户端的下载链接如下： https://sandbox-experiment-files.obs.cn-north-4.myhuaweicloud.com/1993/kubernetes-client-linux-amd64.tar.gz
kubectl安装并配置完成后，使用以下命令验证其安装结果： kubectl get node 若回显如下，则表示安装配置成功： 本任务中需注意以下内容： kubectl应配置于ecs-terminal，否则不得分 使用kubectl get node 后若不返回node节点信息则不得分

任务1步骤：

此任务在 ecs-terminal (预置的或用户自行准备的用于管理集群的ECS/Linux环境) 中执行。

1、登录到 ecs-terminal
2、下载kubectl客户端：
```
wget https://sandbox-experiment-files.obs.cn-north-4.myhuaweicloud.com/1993/kubernetes-client-linux-amd64.tar.gz

```
3、解压下载的压缩包：
```
tar -zxvf kubernetes-client-linux-amd64.tar.gz
```

4、将kubectl二进制文件移动到系统路径下
```
/usr/local/bin
```
赋予执行权限：
解压后，kubectl通常在 kubernetes/client/bin/ 目录下
```
sudo mv kubernetes/client/bin/kubectl /usr/local/bin/
sudo chmod +x /usr/local/bin/kubectl
```
5、验证kubectl版本（可选）：
```
kubectl version --client
```

6、配置kubectl连接集群

在华为云CCE控制台，选择 cce-k8s 集群。
导航到 “集群管理” -> 选择 cce-k8s 集群 -> “连接信息” -> “kubectl”。
按照指引下载 kubeconfig 文件（通常是一个JSON文件或YAML文件）。将其下载到 ecs-terminal。
略，连接信息有命令提示

参考这个，新建文件，然后复制也行
```
cd /home
mkdir -p $HOME/.kube
mv -f kubeconfig.yaml $HOME/.kube/config
```

7、验证kubectl配置和节点连接：
```
kubectl get node
```

预期会显示
```
cce-k8s-node-01
```

(或您自定义的节点名称) 的信息及其状态
```
Ready
```




任务2：创建并使用名为“production”的namespace

得分点：于预制CCE集群创建指定namespace

于CCE集群cce-k8s创建namespace，命名为production

本任务中需注意：namespace命名不匹配不得分

任务2步骤：

在 ecs-terminal (已配置好kubectl) 中执行。

创建名为

production
的namespace：
```
kubectl create namespace production
```
验证创建（可选）：
```
kubectl get namespace production
```
预期输出：
```
NAME STATUS AGE
production Active ...s
```
任务3：创建并使用名为“testing”的namespace

得分点：于预制CCE集群创建指定namespace

于CCE集群cce-k8s创建namespace命名为testing

本任务中需注意：namespace命名不匹配不得分

任务3步骤：

在 ecs-terminal (已配置好kubectl) 中执行。

创建名为

testing
的namespace：
```
kubectl create namespace testing
```
验证创建（可选）：

```
kubectl get namespace testing
```
预期输出：
```
NAME STATUS AGE
testing Active ...s
```


#### 实验三：在CCE集群中部署Deployment工作负载

任务1：使用Deployment部署Nginx

得分点：按照要求成功创建Deployment负载

提示信息如下：

kubectl命令语法：kubectl [command] [TYPE] [NAME] [flags]

Command：指定希望进行的操作，如create，get，describe，delete等。

TYPE：指定操作对象的类型，如deployment，pod，service等。

NAME：指定对象的名字。

flags: 可选的标志位。如--namespace=xxx, --image=xxx等。

于CCE集群cce-k8s创建如下Deployment工作负载：

名称：nginx

命名空间：production

副本数：2

镜像：niginx:1.7.9 (注意：此处可能是笔误，通常为 nginx)

本任务中需注意：名称、命名空间、副本、镜像版本若不匹配均不得分。


任务1步骤：

在 ecs-terminal (已配置好kubectl) 中执行。

使用kubectl命令直接创建Deployment： (假设 "niginx" 为笔误，实际应为 "nginx"。如果题目严格要求 "niginx"，则使用 "niginx")
```
kubectl create deployment nginx --image=nginx:1.7.9 --replicas=2 --namespace=production
```

验证Deployment是否成功创建并在指定命名空间中：
```
kubectl get deployment nginx --namespace=production
```


预期输出应显示名为

nginx 的Deployment，DESIRED为2，CURRENT为2 (可能需要一点时间达到)，READY为2。

查看Pod状态：

```
kubectl get pods --namespace=production -l app=nginx 
```
# kubectl create deployment 会自动给pod打上 app=nginx 的标签
预期会看到两个Pod正在运行或创建中。


任务2：更新Deployment

得分点：按照要求更新任务1已创建的Deployment负载

提示：以下命令可用于Deployment的更新

$ kubectl edit deployment

$ kubectl scale deployment

$ kubectl set image deployment

按照以下要求更新已创建的Deployment：

副本数：2 -> 3

镜像：niginx:1.7.9 -> niginx:1.9.1 (注意：此处可能是笔误，通常为 nginx)

本任务中需注意：若Deployment负载的副本数、镜像版本未按要求更新则不得分。

任务2步骤：

在 ecs-terminal (已配置好kubectl) 中执行。

更新副本数从2到3 (针对名为 nginx 的Deployment，在 production 命名空间)：
```
kubectl scale deployment nginx --replicas=3 --namespace=production
```


2、更新镜像版本从 nginx:1.7.9  到 nginx:1.9.1 ：
```
kubectl set image deployment/nginx nginx=nginx:1.9.1 --namespace=production
```

查看容器名
```
kubectl describe deployment nginx -n production
```

验证更新后的Deployment状态：
```
kubectl get deployment nginx --namespace=production
```

预期输出应显示 nginx Deployment，DESIRED为3，CURRENT为3，READY为3 (可能需要一点时间完成更新)。


4、验证Pod的镜像版本 (可以抽查一个Pod)：
```
kubectl describe pod [pod名称] --namespace=production | grep Image:
# 先用 kubectl get pods -n production 获取一个新创建的Pod名称
```

预期Image字段显示为 nginx:1.9.1 (或 niginx:1.9.1)。