打开终端ssh链接后，首先修改镜像源
```
vim /etc/docker/daemon.json

{
    "registry-mirrors": [
        "https://docker.1panel.live"
        ]
}
```

wq保存退出，重启docker

```
systemctl daemon-reload
systemctl restart docker
```

实验一

0. 拉取httpd镜像
```
docker pull httpd
```

1. 创建dockerfile文件
```
vim dockerfile
```

2. 输入以下内容
```
FROM httpd
MAINTAINER 123@huawei.com
EXPOSE 80
RUN echo "dockerfile test" > /usr/local/apache2/htdocs/index.html
```

3. 构建镜像
```
docker build -t httpd:v1 .
```

4. 运行容器并映射端口
```
docker run -d -p 80:80 --name httpd-test httpd:v1
```

5. 浏览器访问http://EIP:80并多刷新几次，返回以下即可(考点)
```
dockerfile test
```

实验二
```
# 0. 启用私有镜像仓库容器(监听5000端口)(考点)
docker run -d -p 5000:5000 --name registry registry

# 1. 给本地镜像打标签并推送至私有仓库
docker tag httpd:v1 localhost:5000/httpd:v1
docker push localhost:5000/httpd:v1

# 2. 验证是否上传成功
curl -X GET http://localhost:5000/v2/httpd/tags/list

# 3. 返回结果(考点)
{"name":"httpd","tags":["v1"]}
```