### 云容器快速搭建网站

可以参考网站的部署步骤

```
https://support.huaweicloud.com/intl/zh-cn/qs-cce/cce_qs_0004.html
```

任务1：创建RDS数据库

任务1步骤：

没什么好说的，按要求创建服务就行，以下是AI生成的步骤

此任务通过华为云CCE（云容器引擎）控制台完成。

登录华为云控制台。

导航到“云容器引擎 CCE”服务。

创建集群 ：

点击“购买Kubernetes集群”。
计费模式：按需计费
区域：华北-北京四
集群名称：test
版本：选择最新版
集群管理规模：50节点
高可用：否
虚拟私有云(VPC)：选择已创建的虚拟私有云 (如myvpc)
所在子网：选择已创建的子网 (如subnet-myvpc)
网络模型：容器隧道网络
容器网段：自动选择
IPV4服务网段：使用默认网段
高级配置：暂不配置
插件配置：取消勾选“容器监控”和“业务日志”
确认配置并创建集群骨架（控制面）。
等待集群控制面创建成功。

创建节点

(在集群管理界面，选择对应集群，点击“节点管理” -> “创建节点”)：

计费方式：按需计费

当前区域：华北-北京四

可用区：默认 (或根据实际情况选择)

节点类型：弹性云服务器-虚拟机

容器引擎：默认

节点规格：通用型 | s6.xlarge.2 | 4核 | 8GB

操作系统：EulerOS 2.9

节点名称：test-node

登录方式：密码 (自行设置复杂密码)

系统盘/数据盘存储配置：系统盘通常为高IO，大小默认或按需；数据盘根据需要（题目中为高IO，其余默认）。

虚拟私有云：选择已预置的VPC和子网 (应与集群VPC一致)

节点IP：随机分配

弹性公网IP

：自动创建

计费方式：按流量计费
带宽：5Mbit/s
节点购买数量：1台

其余设置保持默认。

确认配置并创建节点。等待节点成功添加到集群。

任务3：通过华为云镜像中心部署无状态工作负载WordPress，并通过外网访问WordPress页面。

得分点：能通过http://ip:端口号成功访问网站登录页面。

WordPress无状态工作负载的创建参数如下：

负载名称：wordpress

实例数量：1

镜像版本：php7.3

WordPress访问类型：LoadBalancer

访问端口：80

容器端口：80

此外需要设置环境变量，此处一共需要设置四个环境变量：

WORDPRESS_DB_HOST：数据库内网IP地址:端口号

WORDPRESS_DB_USER：（与前面mysql创建的账号名称一致）

WORDPRESS_DB_PASSWORD：（与前面mysql创建的账号时设置的密码一致）

WORDPRESS_DB_NAME：（与前面mysql创建的数据库名称一致）

任务3步骤：

确保CCE集群（名为test）和RDS数据库（名为rds-web）已按前述任务要求创建并准备就绪。获取任务1中创建的RDS数据库的内网IP地址、端口号、数据库名、用户名和密码。

在CCE控制台，选择test集群。

导航到“工作负载” -> “无状态负载 (Deployments)”，点击“使用镜像创建”。

或者，部分控制台可能直接有“通过镜像仓库创建”或市场应用。题目指明“通过华为云镜像中心部署”，具体路径可能为 “应用市场” -> 搜索 “WordPress”，然后选择部署到CCE。如果直接创建工作负载：
配置工作负载：

负载名称：wordpress

实例数量：1

容器配置 ：

点击“选择镜像”。
镜像来源选择“华为云SWR镜像”（或公共镜像，搜索WordPress）。题目指定“镜像版本：php7.3”，需要找到对应的WordPress镜像，例如 wordpress:php7.3 。
容器端口：80
环境变量

(非常重要)：

添加以下四个环境变量：（注意安全组放行3306）
WORDPRESS_DB_HOST = [RDS数据库内网IP地址]:[RDS端口号] (例如 192.168.1.10:3306)
WORDPRESS_DB_USER = [任务1中创建的RDS用户名]
WORDPRESS_DB_PASSWORD = [任务1中创建的RDS用户密码]
WORDPRESS_DB_NAME = [任务1中创建的RDS数据库名]
访问设置 (服务)：

访问类型：LoadBalancer ，即负载均衡(弹性公网IP)
协议：TCP
容器端口：80
访问端口 (服务端口)：80
检查其他配置，然后点击“创建负载”。

等待工作负载和LoadBalancer类型的服务创建完成。服务创建完成后，在“服务发现与负载均衡 (Services)”或“网络” -> “服务 (Services)”部分找到名为wordpress（或类似）的服务。

获取该服务的外部IP地址（弹性公网IP）。

在浏览器中输入 http://[外部IP地址]:80。应能看到WordPress的安装或登录页面。
