### CCE网络与存储实战

#### 任务1：创建CCE集群

#### 任务2：安装并配置kubectl

任务在 ecs-terminal (通常指预置的或用户自行准备的用于管理集群的ECS/Linux环境) 中执行。

登录到 ecs-terminal。

下载kubectl客户端 (v1.19.10)：

Bash
```
wget https://dl.k8s.io/v1.19.10/kubernetes-client-linux-amd64.tar.gz
```
解压下载的压缩包：

Bash
```
tar -zxvf kubernetes-client-linux-amd64.tar.gz
```
将kubectl二进制文件移动到系统路径下，例如
```
/usr/local/bin
sudo mv kubernetes/client/bin/kubectl /usr/local/bin/
sudo chmod +x /usr/local/bin/kubectl
```
验证kubectl版本：
```
kubectl version --client
```
配置kubectl连接集群

在华为云CCE控制台，选择 cce-k8s 集群。

导航到 “集群信息” -> “连接信息” -> “kubectl”，点击“点击查看”。

按照指引下载 kubeconfig.json 文件。用scp命令传到服务器上
```
user@sandbox:~/Downloads$ ls
cce-k8s-kubeconfig.yaml
user@sandbox:~/Downloads$ realpath cce-k8s-kubeconfig.yaml
/home/Downloads/cce-k8s-kubeconfig.yaml
user@sandbox:~/Downloads$ scp /home/Downloads/cce-k8s-kubeconfig.yaml root@xx.xx.xx.xx:/home
```
之后按连接信息给的命令继续就行，这里我忘了复制官方的命令，考试时候自己看吧

验证kubectl配置和节点连接：
```
kubectl get node
```
预期会显示

cce-k8s-node-01
节点的信息及其状态 ，例如

Ready


#### 任务3：创建Deployment
在 ecs-terminal (已配置好kubectl) 中执行。

创建目录 (如果题目明确要求在此目录下操作)：
```
mkdir -p labfile/servicefile
cd labfile/servicefile
```
创建
```
nginx-deploy.yaml
```
文件，内容如下：
```
apiVersion: apps/v1
kind: Deployment
metadata:
  name: nginx
spec:
  replicas: 3
  selector:
    matchLabels:
      app: nginx
  template:
    metadata:
      labels:
        app: nginx
    spec:
      containers:
      - name: nginx
        image: nginx # 默认使用nginx:latest
        ports:
        - containerPort: 80
```
使用kubectl应用该YAML文件创建Deployment：
```
kubectl apply -f nginx-deploy.yaml
```
查看创建的Deployment：
```
kubectl get deployment nginx
```
或者查看pod状态
```
kubectl get pods -l app=nginx
```
预期会看到名为

nginx
的Deployment，并且有3个副本正在创建或已运行。v